//=============================================================================
// MiniGameWindow.js
//=============================================================================
/*:
 * @target MZ
 * @plugindesc ミニゲームウィンドウを画面に追加するプラグイン
 * @author Jetsoft
 *
 *
 * @help ミニゲームウィンドウを画面に追加します。
 *
 */
(() => {
	'use strict';

    const pluginName = 'MiniGameWindow';
    
    // Plugin Parameters
    const parameters = PluginManager.parameters(pluginName);

	var _windowScore;
	var _windowScore2;
	var _windowLines;
	var _windowLines2;
	var _windowTyping;

	// マップ上にウィンドウ表示するよ宣言
    const _Scene_Map_stop = Scene_Map.prototype.stop;
    Scene_Map.prototype.stop = function() {
        //_windowA.hide();
        _Scene_Map_stop.apply(this, arguments);
    };

    const _Scene_Map_terminate = Scene_Map.prototype.terminate;
    Scene_Map.prototype.terminate = function() {
        _Scene_Map_terminate.apply(this, arguments);
        if (!SceneManager.isNextScene(Scene_Battle)) {
            _windowScore.hide();
            _windowScore2.hide();
            _windowLines.hide();
            _windowLines2.hide();
            _windowTyping.hide();
        }
    };

    const _Scene_Map_createAllWindows = Scene_Map.prototype.createAllWindows;
    Scene_Map.prototype.createAllWindows = function() {
        _Scene_Map_createAllWindows.apply(this, arguments);
        this.createWindows();
        _windowScore.hide();
        _windowScore2.hide();
        _windowLines.hide();
        _windowLines2.hide();
        _windowTyping.hide();
    };

    Scene_Map.prototype.createWindows = function() {
        _windowScore = new WindowScore();
        this.addWindow(_windowScore);
        _windowScore2 = new WindowScore2();
        this.addWindow(_windowScore2);
        _windowLines = new WindowLines();
        this.addWindow(_windowLines);
        _windowLines2 = new WindowLines2();
        this.addWindow(_windowLines2);
        _windowTyping = new WindowTyping();
        this.addWindow(_windowTyping);
    };

    const _Scene_Map_callMenu = Scene_Map.prototype.callMenu;
    Scene_Map.prototype.callMenu = function() {
        _Scene_Map_callMenu.apply(this, arguments);
        //_windowA.hide();
    };
	
    //
    // WindowScore
    //

    function WindowScore() {
        this.initialize(...arguments);
    }

	WindowScore.prototype = Object.create(Window_Base.prototype);
	WindowScore.prototype.constructor = WindowScore;

    WindowScore.prototype.initialize = function() {
        const rect = new Rectangle(0, 0, Graphics.boxWidth, Graphics.boxHeight);
        Window_Base.prototype.initialize.call(this, rect);

        this.width = 0;
        this.height = 0;
    };

	WindowScore.prototype.resetFontSettings = function() {
	    this.contents.fontFace = $gameSystem.mainFontFace();
	    this.contents.fontSize = 48;
	    this.resetTextColor();
		this.contents.textColor = 'black';
		//this.contents.outlineColor = 'white';
		this.contents.outlineColor = "rgba(0, 0, 0, 0)";
	};

    WindowScore.prototype.update = function() {
        Window_Base.prototype.update.call(this);

        this.refresh();
    };

    WindowScore.prototype.loadWindowskin = function() {
        //this.windowskin = ImageManager.loadSystem('WindowWhite');
    };

	// ウィンドウに載せる内容
	WindowScore.prototype.refresh = function() {
		var gametype = $gameVariables.value(71);
		if (gametype == 0) return;

        this.width = 380;
        this.height = 170;
        //this.x = 20;
        //this.y = 20;
        this.x = 90;
        this.y = 0;
	    this.contents.clear();

		var time0 = $gameVariables.value(61);
		var nowtime = new Date().getTime();
		var keika = Math.floor((nowtime - time0) / 1000);
		if (keika > 60) keika = 60;

		var nokori = 60 - keika;
		var score = $gameVariables.value(67);
		var goal = $gameVariables.value(75);

		this.drawText(String(nokori), 0, 10);

		if (nokori == 0) {
			$gameVariables.setValue(71,0);
			_windowTyping.hide();
			if (gametype==1) {
				$gameTemp.reserveCommonEvent(35);
			}
			if (gametype==2) {
				$gameVariables.setValue(71,99);
				$gameTemp.reserveCommonEvent(405);
			}
			if (gametype==3) {
				$gameSwitches.setValue(6,true);
				$gameTemp.reserveCommonEvent(314);
			}
		}

		if (gametype==2) {
			var ice = $gameVariables.value(161);
			var itigo = $gameVariables.value(162);
			var mattya = $gameVariables.value(163);
			var blue = $gameVariables.value(164);
			var order = $gameVariables.value(166);
			var y = 0;
			var flagreset = false;
			var ratio = 30;
			if (ice>0) {
				//y = 475 + 250 * ((ice-1) / 240);
				y = 655 + 120 * ((ice-1) / 240);
				ratio = 20 - 10 * ((ice-1) / 240);
				$gameScreen.showPicture(20,"minigame/ice01",1,640,y,ratio,ratio,255,0);
				$gameVariables.setValue(161,ice-1);
				if (ice==1) $gameSwitches.setValue(13,true);
			}
			if (itigo>0) {
				//$gameScreen.showPicture(22,"minigame/ice01",1,740,475,30,30,255,0);
				$gameScreen.showPicture(22,"minigame/ice01",1,640,655,20,20,255,0);
				//y = 475 - 250 * ((itigo-1) / 120);
				y = 655 - 120 * ((itigo-1) / 120);
				$gameScreen.showPicture(21,"minigame/siroppu01",1,640,y,20,20,255,0);
				SceneManager._scene._spriteset._pictureContainer.children[20].mask = SceneManager._scene._spriteset._pictureContainer.children[21];
				$gameVariables.setValue(162,itigo-1);
				if (itigo==1) {
					if (order==1) {
						//SoundManager.playOk();
						AudioManager.playSe({"name":"Chime1","volume":90,"pitch":100,"pan":0})
						setIceLineSuccess();
						score += 20;
						$gameVariables.setValue(67,score);
						$gameTemp.reserveCommonEvent(402);
					}
					else {
						SoundManager.playBuzzer();
						setIceLineFail();
						$gameTemp.reserveCommonEvent(402);
					}
					flagreset = true;
				}
			}
			if (mattya>0) {
				$gameScreen.showPicture(22,"minigame/ice01",1,640,655,20,20,255,0);
				y = 655 - 120 * ((mattya-1) / 120);
				$gameScreen.showPicture(21,"minigame/siroppu03",1,640,y,20,20,255,0);
				SceneManager._scene._spriteset._pictureContainer.children[20].mask = SceneManager._scene._spriteset._pictureContainer.children[21];
				$gameVariables.setValue(163,mattya-1);
				if (mattya==1) {
					if (order==2) {
						//SoundManager.playOk();
						AudioManager.playSe({"name":"Chime1","volume":90,"pitch":100,"pan":0})
						setIceLineSuccess();
						score += 20;
						$gameVariables.setValue(67,score);
						$gameTemp.reserveCommonEvent(402);
					}
					else {
						SoundManager.playBuzzer();
						setIceLineFail();
						$gameTemp.reserveCommonEvent(402);
					}
					flagreset = true;
				}
			}
			if (blue>0) {
				$gameScreen.showPicture(22,"minigame/ice01",1,640,655,20,20,255,0);
				y = 655 - 120 * ((blue-1) / 120);
				$gameScreen.showPicture(21,"minigame/siroppu02",1,640,y,20,20,255,0);
				SceneManager._scene._spriteset._pictureContainer.children[20].mask = SceneManager._scene._spriteset._pictureContainer.children[21];
				$gameVariables.setValue(164,blue-1);
				if (blue==1) {
					if (order==3) {
						//SoundManager.playOk();
						AudioManager.playSe({"name":"Chime1","volume":90,"pitch":100,"pan":0})
						setIceLineSuccess();
						score += 20;
						$gameVariables.setValue(67,score);
						$gameTemp.reserveCommonEvent(402);
					}
					else {
						SoundManager.playBuzzer();
						setIceLineFail();
						$gameTemp.reserveCommonEvent(402);
					}
					flagreset = true;
				}
			}
			if (flagreset) {
				$gameScreen.erasePicture(20);
				$gameScreen.erasePicture(21);
				$gameScreen.erasePicture(22);
				$gameVariables.setValue(161,0);
				$gameVariables.setValue(162,0);
				$gameVariables.setValue(163,0);
				$gameVariables.setValue(164,0);
				$gameVariables.setValue(166,0);
				$gameSwitches.setValue(13,false);
			}
		}
	};

	function setIceLineSuccess() {
		var r = Math.floor(Math.random() * 5);
		if (r==0) {
			$gameVariables.setValue(69,'じょうず♡じょうず♡');
		}
		if (r==1) {
			$gameVariables.setValue(69,'亀頭いい子いい子してあげます♡');
		}
		if (r==2) {
			$gameVariables.setValue(69,'お口のご褒美に一歩前進♡');
		}
		if (r==3) {
			$gameVariables.setValue(69,'グッドです♡誉めてあげます♡');
		}
		if (r==4) {
			$gameVariables.setValue(69,'ご褒美あげてもいいですよ♡');
		}
	}

	function setIceLineFail() {
		var r = Math.floor(Math.random() * 5);
		if (r==0) {
			$gameVariables.setValue(69,'注文と違うみたいですよー？');
		}
		if (r==1) {
			$gameVariables.setValue(69,'チンポに栄養全振りなんですかー？');
		}
		if (r==2) {
			$gameVariables.setValue(69,'お客さんプンプンですよー');
		}
		if (r==3) {
			$gameVariables.setValue(69,'勃起するしか能ないんですかー？');
		}
		if (r==4) {
			$gameVariables.setValue(69,'あーお客さん帰っちゃった');
		}
	}

    //
    // WindowScore2
    //

    function WindowScore2() {
        this.initialize(...arguments);
    }

	WindowScore2.prototype = Object.create(Window_Base.prototype);
	WindowScore2.prototype.constructor = WindowScore2;

    WindowScore2.prototype.initialize = function() {
        const rect = new Rectangle(0, 0, Graphics.boxWidth, Graphics.boxHeight);
        Window_Base.prototype.initialize.call(this, rect);

        this.width = 0;
        this.height = 0;
    };

	WindowScore2.prototype.resetFontSettings = function() {
	    this.contents.fontFace = $gameSystem.mainFontFace();
	    this.contents.fontSize = 36;
	    this.resetTextColor();
		this.contents.textColor = 'white';
		this.contents.outlineColor = 'black';
	};

    WindowScore2.prototype.update = function() {
        Window_Base.prototype.update.call(this);

        this.refresh();
    };

    WindowScore2.prototype.loadWindowskin = function() {
        //this.windowskin = ImageManager.loadSystem('WindowWhite');
    };

	// ウィンドウに載せる内容
	WindowScore2.prototype.refresh = function() {
		var gametype = $gameVariables.value(71);
		if (gametype == 0) return;

        this.width = 160;
        this.height = 170;
        //this.x = 20;
        //this.y = 20;
        this.x = 370;
        this.y = -8;
	    this.contents.clear();

		var time0 = $gameVariables.value(61);
		var nowtime = new Date().getTime();
		var keika = Math.floor((nowtime - time0) / 1000);
		if (keika > 60) keika = 60;

		var nokori = 60 - keika;
		var score = $gameVariables.value(67);
		var goal = $gameVariables.value(75);

		//this.drawText('Time:'+String(nokori), 10, 5);
		//this.drawText('Score:'+String(score), 10, 53);
		//this.drawText('Goal:'+String(goal), 10, 101);
		this.drawTextEx(String(score), 40, 3);
		this.drawTextEx("\\FS[24]" + String(goal), 0, 40);

		if (nokori>0 && score >= goal) {
			$gameVariables.setValue(71,0);
			_windowTyping.hide();
			if (gametype==1) {
				$gameTemp.reserveCommonEvent(34);
			}
			if (gametype==2) {
				$gameVariables.setValue(71,99);
				$gameTemp.reserveCommonEvent(404);
			}
			if (gametype==3) {
				$gameSwitches.setValue(6,true);
				$gameTemp.reserveCommonEvent(313);
			}
		}
	};

    //
    // WindowLines
    //

    function WindowLines() {
        this.initialize(...arguments);
    }

	WindowLines.prototype = Object.create(Window_Base.prototype);
	WindowLines.prototype.constructor = WindowLines;

    WindowLines.prototype.initialize = function() {
        const rect = new Rectangle(0, 0, Graphics.boxWidth, Graphics.boxHeight);
        Window_Base.prototype.initialize.call(this, rect);

        this.width = 0;
        this.height = 0;
    };

	WindowLines.prototype.resetFontSettings = function() {
		var gametype = $gameVariables.value(71);
	    this.contents.fontFace = $gameSystem.mainFontFace();
	    this.contents.fontSize = 36;
	    this.resetTextColor();
		this.contents.textColor = 'black';
		this.contents.outlineColor = 'white';
	};

    WindowLines.prototype.update = function() {
        Window_Base.prototype.update.call(this);

        this.refresh();
    };

    WindowLines.prototype.loadWindowskin = function() {
        //this.windowskin = ImageManager.loadSystem('WindowWhite');
    };

	// ウィンドウに載せる内容
	WindowLines.prototype.refresh = function() {
		var gametype = $gameVariables.value(71);
		if (gametype == 0) return;

		if (gametype == 1) {
	        //this.width = 400;
	        this.width = 460;
	        this.height = 120;
	        this.x = 280;
	        this.y = 220;
		    this.contents.clear();
			this.drawTextEx("\\FS[24]" + $gameVariables.value(69), 4, 24);
		}

		if (gametype == 2) {
		console.log("*** WindowLines1 refresh ***");
	        //this.width = 400;
	        this.width = 460;
	        this.height = 120;
	        this.x = 434;
	        this.y = 177;
		    this.contents.clear();
			this.drawTextEx("\\FS[24]" + $gameVariables.value(69), 4, 24);
		}

		if (gametype == 3) {
	        //this.width = 400;
	        this.width = 460;
	        this.height = 120;
	        this.x = 454;
	        this.y = 177;
		    this.contents.clear();
			this.drawTextEx("\\FS[24]" + $gameVariables.value(69), 4, 24);
		}

	};

    //
    // WindowLines2
    //

    function WindowLines2() {
        this.initialize(...arguments);
    }

	WindowLines2.prototype = Object.create(Window_Base.prototype);
	WindowLines2.prototype.constructor = WindowLines2;

    WindowLines2.prototype.initialize = function() {
        const rect = new Rectangle(0, 0, Graphics.boxWidth, Graphics.boxHeight);
        Window_Base.prototype.initialize.call(this, rect);

        this.width = 0;
        this.height = 0;
    };

	WindowLines2.prototype.resetFontSettings = function() {
	    this.contents.fontFace = $gameSystem.mainFontFace();
	    this.contents.fontSize = 18;
	    this.resetTextColor();
		this.contents.textColor = 'black';
		this.contents.outlineColor = 'white';
	};

    WindowLines2.prototype.update = function() {
        Window_Base.prototype.update.call(this);

        this.refresh();
    };

    WindowLines2.prototype.loadWindowskin = function() {
        //this.windowskin = ImageManager.loadSystem('WindowWhite');
    };

	// ウィンドウに載せる内容
	WindowLines2.prototype.refresh = function() {
		var gametype = $gameVariables.value(71);
		if (gametype == 0) return;

		if (gametype == 99) {
		console.log("*** WindowLines2 refresh extra ***");
	        this.width = 240;
	        this.height = 60;
	        this.x = 1000;
	        this.y = 690;
		    this.contents.clear();
			$gameVariables.setValue(71,0);
		}

		if (gametype == 2) {
		console.log("*** WindowLines2 refresh ***");
	        this.width = 240;
	        this.height = 60;
	        this.x = 1000;
	        this.y = 690;
		    this.contents.clear();
			this.drawText($gameVariables.value(70), 2, 2);
		}
	};

    //
    // WindowTyping
    //

    function WindowTyping() {
        this.initialize(...arguments);
    }

	WindowTyping.prototype = Object.create(Window_Base.prototype);
	WindowTyping.prototype.constructor = WindowTyping;

    WindowTyping.prototype.initialize = function() {
        const rect = new Rectangle(0, 0, Graphics.boxWidth, Graphics.boxHeight);
        Window_Base.prototype.initialize.call(this, rect);

        this.width = 0;
        this.height = 0;
    };

	WindowTyping.prototype.resetFontSettings = function() {
	    this.contents.fontFace = $gameSystem.mainFontFace();
	    //this.contents.fontSize = 36;
	    this.contents.fontSize = 24;
	    this.resetTextColor();
		this.contents.textColor = 'black';
		this.contents.outlineColor = 'white';
	};

    WindowTyping.prototype.update = function() {
        Window_Base.prototype.update.call(this);

        this.refresh();
    };

    WindowTyping.prototype.loadWindowskin = function() {
        //this.windowskin = ImageManager.loadSystem('WindowWhite');
    };

	// ウィンドウに載せる内容
	WindowTyping.prototype.refresh = function() {
		var gametype = $gameVariables.value(71);
		if (gametype != 1) return;

        this.width = 1120;
        this.height = 240;
        this.x = 120;
        this.y = 660;
	    this.contents.clear();
		var mondai2 = '';
		var mondai3 = '';
		var mondai = $gameVariables.value(65);
		var len = mondai.length;
		var len1 = this.getCharacterCount(mondai,1000);
		var len2 = 0;
		var mondai1 = mondai.substr(0,len1);
		if (len != len1) {
			var mondainokori = mondai.substr(len1);
			len2 = this.getCharacterCount(mondainokori,1000);
			mondai2 = mondainokori.substr(0,len2);
			if (len != len1 + len2) {
				mondai3 = mondainokori.substr(len2);
			}
		}
		//console.log('*** len1:' + String(len1));
		//console.log('*** len2:' + String(len2));
		var linenum = 40;

		var mondai_jp = $gameVariables.value(64);
		var mondai_jp2 = '';
		var len_jp = mondai_jp.length;
		var len_jp1 = this.getCharacterCount(mondai_jp,1000);
		var len_jp2 = 0;
		var mondai_jp1 = mondai_jp.substr(0,len_jp1);
		if (len_jp != len_jp1) {
			mondai_jp2 = mondai_jp.substr(len_jp1);
		}

		this.drawText(mondai_jp1, 10, 36);
		this.drawText(mondai_jp2, 10, 66);

		var redcount = $gameVariables.value(66);
		var redcount1 = 0;
		var redcount2 = 0;
		var redcount3 = 0;
		if (redcount <= len1)
		{
			redcount1 = redcount;
			redcount2 = 0;
			redcount3 = 0;
		}
		else {
			if (redcount <= len1 + len2) {
				redcount1 = len1;
				redcount2 = redcount - len1;
				redcount3 = 0;
			}
			else {
				redcount1 = len1;
				redcount2 = len2;
				redcount3 = redcount - len1 - len2;
			}
		}

		if (redcount1 == 0) {
			this.drawTextEx("\\C[15]" + mondai1, 10, 112);
		}
		else {
			var str1 = mondai1.substr(0,redcount1);
			var str2 = mondai1.substr(redcount1);
			this.drawTextEx("\\C[2]" + str1 + "\\C[15]" + str2, 10, 112);
		}

		if (mondai2.length!=0) {
			if (redcount2 == 0) {
				this.drawTextEx("\\C[15]" + mondai2, 10, 132);
			}
			else {
				var str1 = mondai2.substr(0,redcount2);
				var str2 = mondai2.substr(redcount2);
				this.drawTextEx("\\C[2]" + str1 + "\\C[15]" + str2, 10, 132);
			}
		}

		if (mondai3.length!=0) {
			if (redcount3 == 0) {
				this.drawTextEx("\\C[15]" + mondai3, 10, 152);
			}
			else {
				var str1 = mondai3.substr(0,redcount3);
				var str2 = mondai3.substr(redcount3);
				this.drawTextEx("\\C[2]" + str1 + "\\C[15]" + str2, 10, 152);
			}
		}

		if ($gameSwitches.value(14)) checkKey();
	};

	WindowTyping.prototype.getCharacterCount = function(str,width) {
	//function getCharacterCount(str,width) {
		var len = str.length;
		if (len==0) return 0;
		var i=0;
		var w=0;
		for (i=0;i<len;i++) {
			w = this.textWidth(str.substr(0,i+1));
			if (w>width) return i-1;
		}
		return len;
	}
	
	Game_System.prototype.showMiniGame = function() {
	console.log('***showMiniGame');
		var gametype = $gameVariables.value(71);
		if (gametype == 1) {
	        _windowScore.show();
	        _windowScore2.show();
	        _windowLines.show();
	        _windowTyping.show();
		}
		if (gametype == 2) {
	        _windowScore.show();
	        _windowScore2.show();
	        _windowLines.show();
	        _windowLines2.show();
		}
		if (gametype == 3) {
	        _windowScore.show();
	        _windowScore2.show();
	        _windowLines.show();
		}
	};

	Game_System.prototype.hideMiniGame = function() {
		var gametype = $gameVariables.value(71);
		if (gametype == 0) {
	        _windowScore.hide();
	        _windowScore2.hide();
	        _windowLines.hide();
	        _windowTyping.hide();
		}
		if (gametype == 1) {
	        _windowScore.hide();
	        _windowScore2.hide();
	        _windowLines.hide();
	        _windowTyping.hide();
		}
		if (gametype == 2) {
	        _windowScore.hide();
	        _windowScore2.hide();
	        _windowLines.hide();
	        _windowLines2.hide();
		}
		if (gametype == 3) {
	        _windowScore.hide();
	        _windowScore2.hide();
	        _windowLines.hide();
		}
	};

	function getMondai(num) {
		var data = [
'今日の服も可愛いね',
'キレイな目してるよね',
'声聞くと落ち着くな',
'一緒にいると楽しいな',
'笑顔が可愛いね',
'ずっとこうして一緒にいたいな',
'ハグすると落ち着くんだって',
'目を見てるだけで嬉しい気持ちになっちゃうな',
'もっと一緒にいる時間があればいいのに',
'手つないでると嬉しくなっちゃうんだよね',
'今日は良い天気だから飛行機雲がはっきり見えるね',
'散歩って適度な運動になるし日光浴も出来るから体にいいんだって',
'今映画館でやってる映画にトータルリコーダー逆襲のソプラノってあるでしょ',
'プールで泳ぐよりも海で泳ぐ方が運動量が高くなっていいんだって',
'今度ミュージカルになる仁義なきバトルオブユニバースの主人公三毛猫になるって',
'ここの公園、春になるとフラワーフェスティバルするらしいよ',
'竹垣に竹立てかけた縦書き竹田の盾って言って、無理なキスね',
'どこでも好きな時代の好きな国に行けるとしたら、どこに行く？',
'犬と猫だけで作ってる舞台、毎回見るたび違って良いんだって',
'伊賀と甲賀が緊迫状態、忍術を仕掛ける秒読みか？これどう思う？',
'勃起したペニスが愛液で濡れた膣穴に挿入され、膣内を擦る事によって快楽が発生して射精する行為を、なんて言う',
'射精し精液が付いているペニスを、女性が舌で精子を舐め取り、口で男根をキレイにする行為を、なんて言う？',
'人が大勢見ている前でセックスするのと、人がいるけど隠れてセックスするの、どっちの方をやってみたい？',
'射精しても抜かずに限界までセックスしたら、何回戦までいけると思う？本当に一度もマンコから抜かずにずっと挿入したままで',
'コンドーム付けたセックスとゴム無しででやる種付け生ハメセックスって、女の子からするとどっちの方が気持ちいいの？'
		];
		return data[num];
	}

	function getMondaiEiji(num) {
		var data = [
'KYOUNOFUKUMOKAWAIINE',
'KIREINAMESITERUYONE',
'KOEKIKUTOOTITUKUNA',
'ISSYONIIRUTOTANOSIINA',
'EGAOGAKAWAIINE',
'ZUTTOKOUSITEISSYONIITAINA',
'HAGUSURUTOOTITUKUNNDATTE',
'MEWOMITERUDAKEDEURESIIKIMOTININATYAUNA',
'MOTTOISSYONIIRUJIKANGAAREBAIINONI',
'TEWOTUNAIDEIRUTOURESIKUNATTYAUNNDAYONE',
'KYOUWAIITENKIDAKARAHIKOUKIGUMOGAHAKKIRIMIERUNE',
'SANPPOTTETEKIDONAUNDOUNINARUSINIKKOUYOKUMODEKIRUKARAKARADANIIINNDATTE',
'IMAEIGAKANDEYATTERUEIGANITO-TARURIKO-DA-GYAKUSYUUNOSOPURANOTTEARUDESYO',
'PU-RUDEOYOGUYORIMOUMIDEOYOGUHOUGAUNDOURYOUGATAKAKUNATTEIINNDATTE',
'KONDOMYU-JIKARUNINARUJINGINAKIBATORUOBUYUNIBA-SUNOSYUJINKOUMIKENEKONINARUTTE',
'KOKONOKOUENHARUNINARUTOFURAWA-FESUTXIBARUSURURASIIYO',
'TAKEGAKINITAKETATEKAKETATATEGAKITAKEDANOTATETTEITTEMURINAKISUNE',
'DOKODEMOSUKINAJIDAINOSUKINAKUNINIIKERUTOSITARADOKONIIKU',
'INUTONEKODAKEDETUKUTTERUBUTAIMAIKAIMIRUTABINITIGATTEIINNDATTE',
'IGATOKOUGAGAKINNPAKUJYOUTAININNJYUTUWOSIKAKERUBYOUYOMIKAKOREDOUOMOU',
'BOKKISITAPENISUGAAIEKIDENURETATITUANANISOUNYUUSARETITUANAWOSURUKOTONIYOTTEKAIRAKUGAHASSEISITESYASEISURUKOUIWONANNTEIU',
'SYASEISISSEIEKIGATUITEIRUPENISUWOJYOSEIGASITADENAMETORIKUTIDEDANKONWOKIREINISURUKOUIWONANNTEIU',
'HITOGAOOZEIMITEIRUMAEDESEKKUSUSURUNOTOHITOGAIRUKEDOKAKURETESEKKUSUSURUNODOTTINOHOUWOYATTEMITAI',
'SYASEISITEMONUKAZUNIGENKAIMADESEKKUSUSITARANANKAISENMADEIKERUTOOMOUHONTOUNIITIDOMOMANKOKARANUKAZUNIZUTTOSOUNYUUSITAMAMADE',
'KONDO-MUTUKETASEKKUSUTOGOMUNASIDEYARUTANETUKENAMAHAMESEKKUSUTTEONNNANOKOKARASURUTODOTTINOHOUGAKIMOTIIINO'
		];
		return data[num];
	}

	function getSerifu(num) {
		var data = [
'ありがとう♡',
'きゃっ♡うれしい♡',
'じゃあお話ししよ♡',
'あたしも楽しい♡',
'お世辞でも嬉しい♡',
'あたしもずっとギュッとしてたい♡',
'じゃあもっとハグして♡',
'そんなに見つめられると…恥ずかしい♡',
'二人でいると本当に時間忘れちゃう♡',
'分かる～♡あたしも今すっごい嬉しい♡',
'あっ！本当にキレイな飛行機雲！',
'それじゃあもっと一緒に歩こうね♡',
'興行収入８週連続１位のやつ？',
'海行きたい！新しい水着着たい！',
'へぇ～柴犬だと思ったのに！',
'そうなんだ～！その時また来たいね♡',
'竹垣に立てか…あ～っ！もうっ！ちゅっ♡',
'ピラミッド製作中のエジプトかな',
'監督がシェパードで作家がノルウェージャンフォレストなんでしょ？',
'忍者屋敷デートとかは面白そうだと思う',
'ゴム無し生ハメセックス♡…したくなっちゃった？',
'お掃除フェラ♡…いつもしてあげてるでしょ♡',
'隠れてがいいな…それにしても変態な質問ね♡好きだけど♡',
'絶倫だし…7回はいけそう？その時はあたしも頑張るよ♡',
'断然生ハメかな♡中出ししてもらえるともっと気持ちいい♡気分的にね♡'
		];
		return data[num];
}

	function getMondaiArray() {
		//var array = [0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19];
		var array = [0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24];

		for(var i = (array.length - 1); 0 < i; i--){
			// 0〜(i+1)の範囲で値を取得
			var r = Math.floor(Math.random() * (i + 1));
			// 要素の並び替えを実行
			var tmp = array[i];
			array[i] = array[r];
			array[r] = tmp;
		}
		return array;
	}

	Game_System.prototype.getMondai = function(num) {
		return getMondai(num);
	}

	Game_System.prototype.getMondaiEiji = function(num) {
		return getMondaiEiji(num);
	}

	Game_System.prototype.getSerifu = function(num) {
		return getSerifu(num);
	}

	Game_System.prototype.getMondaiArray = function() {
		return getMondaiArray();
	}

	Game_System.prototype.getMondaiNum = function(array,i) {
		return array[i];
	}

	function checkKey() {
		if ($gameVariables.value(63)==0) $gameVariables.setValue(63,'');

		var key = '';
		if (Input.isTriggered('A')) key = 'A';
		if (Input.isTriggered('B')) key = 'B';
		if (Input.isTriggered('C')) key = 'C';
		if (Input.isTriggered('D')) key = 'D';
		if (Input.isTriggered('E')) key = 'E';
		if (Input.isTriggered('F')) key = 'F';
		if (Input.isTriggered('G')) key = 'G';
		if (Input.isTriggered('H')) key = 'H';
		if (Input.isTriggered('I')) key = 'I';
		if (Input.isTriggered('J')) key = 'J';
		if (Input.isTriggered('K')) key = 'K';
		if (Input.isTriggered('L')) key = 'L';
		if (Input.isTriggered('M')) key = 'M';
		if (Input.isTriggered('N')) key = 'N';
		if (Input.isTriggered('O')) key = 'O';
		if (Input.isTriggered('P')) key = 'P';
		if (Input.isTriggered('Q')) key = 'Q';
		if (Input.isTriggered('R')) key = 'R';
		if (Input.isTriggered('S')) key = 'S';
		if (Input.isTriggered('T')) key = 'T';
		if (Input.isTriggered('U')) key = 'U';
		if (Input.isTriggered('V')) key = 'V';
		if (Input.isTriggered('W')) key = 'W';
		if (Input.isTriggered('X')) key = 'X';
		if (Input.isTriggered('Y')) key = 'Y';
		if (Input.isTriggered('Z')) key = 'Z';
		if (Input.isTriggered('-')) key = '-';
		if (key != '') {
			$gameVariables.setValue(63,key);
		}
		else {
			if ($gameVariables.value(63) !='') {
				var str = $gameVariables.value(65);
				var seikai = str.substr($gameVariables.value(66), 1);
				if ($gameVariables.value(63) == seikai) {
					SoundManager.playOk();
					$gameVariables.setValue(66,$gameVariables.value(66)+1);
					$gameVariables.setValue(67,$gameVariables.value(67)+1);
					$gameVariables.setValue(68,$gameVariables.value(68)+1);
					if ($gameVariables.value(68) < 5) {
						if ($gameVariables.value(68) >= 1) {
							$gameScreen.showPicture(91,"minigame/heart120",0,20,290,100,100,255,0);
						}
						if ($gameVariables.value(68) >= 2) {
							$gameScreen.showPicture(92,"minigame/heart120",0,300,200,100,100,255,0);
						}
						if ($gameVariables.value(68) >= 3) {
							$gameScreen.showPicture(93,"minigame/heart120",0,360,340,100,100,255,0);
						}
						if ($gameVariables.value(68) >= 4) {
							$gameScreen.showPicture(94,"minigame/heart120",0,800,240,100,100,255,0);
						}
					}

					if ($gameVariables.value(68) >= 5 && $gameSwitches.value(15) == false) {
/*
						$gameScreen.showPicture(95,"heart60",0,500,500,100,100,255,0);
						$gameScreen.movePicture(91,0,250,250,100,100,255,0,120);
						$gameScreen.movePicture(92,0,250,250,100,100,255,0,120);
						$gameScreen.movePicture(93,0,250,250,100,100,255,0,120);
						$gameScreen.movePicture(94,0,250,250,100,100,255,0,120);
						$gameScreen.movePicture(95,0,250,250,100,100,255,0,120);
						//$gameVariables.setValue(68,0);
*/
						$gameVariables.setValue(67,$gameVariables.value(67)+10);
						$gameScreen.showPicture(91,"minigame/heart120",0,20,290,100,100,255,0);
						$gameScreen.showPicture(92,"minigame/heart120",0,300,200,100,100,255,0);
						$gameScreen.showPicture(93,"minigame/heart120",0,360,340,100,100,255,0);
						$gameScreen.showPicture(94,"minigame/heart120",0,800,240,100,100,255,0);
						$gameScreen.showPicture(95,"minigame/heart120",0,1000,370,100,100,255,0);
						$gameSwitches.setValue(15,true);
						$gameTemp.reserveCommonEvent(33);
					}
					if ($gameVariables.value(66) == str.length) {
						$gameTemp.reserveCommonEvent(36);
					}
				}
				else {
					SoundManager.playBuzzer();
					$gameVariables.setValue(68,0);
				}
				$gameVariables.setValue(63,'');
			}
		}
	}

})();
